//stikanim.cpp
//stick figure keyboard controlled animation
//Joe Barodin

#include <iostream.h>
#include <graphics.h>
#include <math.h>
#include <conio.h>
#include <dos.h>

int xpos=320; 		//x position of stick figure at all times
char key='z';		//user input read during animation
char dir='r';		//set initial direction of stick figure to 'right'
char walk='f';		//set 'is walking?' to false
float size=35;    //set initial scaling factor of stick figure to 35

void rhead (float s, int x, int y)
{
	circle(x, y, s);												//	head
	line(x+0.95*s, y-0.31*s, x+1.15*s, y+0.31*s);		// nose
	line(x+1.15*s,y+0.31*s,x+0.95*s,y+0.31*s);
	circle(x+0.7*s,y-0.41*s,0.1*s);							//	eye
	arc(x+0.75*s,y-0.85*s,245,270,1.5*s);	 				// mouth
	arc(x-1.35*s,y-0.95*s,0,40,s);							//	hair
	arc(x-s,y-s,0,40,s);
	arc(x-0.65*s,y-0.95*s,0,40,s);
}


void lhead (float s, int x, int y)
{
	circle(x, y, s);												//	head
	line(x-0.95*s,y-0.31*s,x-1.15*s,y+0.31*s);   		//	nose
	line(x-1.15*s,y+0.31*s,x-0.95*s,y+0.31*s);
	circle(x-0.7*s,y-0.41*s,0.1*s);							//	eye
	arc(x-0.75*s,y-0.85*s,270,295,1.5*s);					//	mouth
	arc(x+1.35*s,y-0.95*s,140,180,s);						//	hair
	arc(x+s,y-s,140,180,s);
	arc(x+0.65*s,y-0.95*s,140,180,s);
}


void rstride (float s, int x, int y)
{
	rhead(s, x, y);												// head
	line(x,y+s,x,y+3.5*s);	   								// body
	line(x,y+3.5*s,x+1.25*s,y+5.5*s);						// front leg
	line(x+1.25*s,y+5.5*s,x+1.79*s,y+5.4*s);				// front foot
	line(x,y+3.5*s,x-0.4*s,y+4.5*s);	   					// rear thigh
	line(x-0.4*s,y+4.5*s,x-1.25*s,y+5.35*s);				// rear shin
	line(x-1.25*s,y+5.35*s,x-0.75*s,y+5.55*s); 			// rear foot
	line(x,y+1.4*s,x+1.5*s,y+3.65*s);						// front arm
	circle(x+1.56*s,y+3.73*s,0.1*s);  						// front hand
	line(x,y+1.4*s,x-0.75*s,y+4*s);	   					// rear arm
	circle(x-0.78*s,y+4.08*s,0.1*s);		   				// rear hand
}


void lstride (float s, int x, int y)
{
	lhead(s, x, y);												// head
	line(x,y+s,x,y+3.5*s);										// body
	line(x,y+3.5*s,x-1.25*s,y+5.5*s);						// front leg
	line(x-1.25*s,y+5.5*s,x-1.79*s,y+5.4*s);				// front foot
	line(x,y+3.5*s,x+0.4*s,y+4.5*s);							// rear thigh
	line(x+0.4*s,y+4.5*s,x+1.25*s,y+5.35*s);				// rear shin
	line(x+1.25*s,y+5.35*s,x+0.75*s,y+5.55*s);		   // rear foot
	line(x,y+1.4*s,x-1.5*s,y+3.65*s);						// front arm
	circle(x-1.56*s,y+3.73*s,0.1*s);							// front hand
	line(x,y+1.4*s,x+0.75*s,y+4*s);							// rear arm
	circle(x+0.78*s,y+4.08*s,0.1*s);							// rear hand
}


void rmidwalk(float s, int x, int y)
{
	rhead(s, x, y);												// head
	line(x,y+s,x,y+3.5*s);	  									// body
	line(x,y+3.5*s,x,y+5.5*s);									// front leg
	line(x,y+5.5*s,x+0.54*s,y+5.5*s);			         // front foot
	line(x,y+3.5*s,x+0.5*s,y+4.4*s);							// rear thigh
	line(x+0.5*s,y+4.4*s,x-0.75*s,y+5.35*s);				// rear shin
	line(x-0.75*s,y+5.35*s,x-0.25*s,y+5.45*s);		   // rear foot
	line(x,y+1.4*s,x+0.25*s,y+4.25*s);						// front arm
	circle(x+0.25*s,y+4.35*s,0.1*s);							// front hand
	line(x,y+1.4*s,x-0.25*s,y+4.25*s);						// rear arm
	circle(x-0.25*s,y+4.35*s,0.1*s);							// rear hand
}


void lmidwalk(float s, int x, int y)
{
	lhead(s, x, y);												// head
	line(x,y+s,x,y+3.5*s);										// body
	line(x,y+3.5*s,x,y+5.5*s);									// front leg
	line(x,y+5.5*s,x-0.54*s,y+5.5*s);						// front foot
	line(x,y+3.5*s,x-0.5*s,y+4.4*s);							// rear thigh
	line(x-0.5*s,y+4.4*s,x+0.75*s,y+5.35*s);				// rear shin
	line(x+0.75*s,y+5.35*s,x+0.25*s,y+5.45*s);	 		// rear foot
	line(x,y+1.4*s,x-0.25*s,y+4.25*s);						// front arm
	circle(x-0.25*s,y+4.35*s,0.1*s);							// front hand
	line(x,y+1.4*s,x+0.25*s,y+4.25*s);						// rear arm
	circle(x+0.25*s,y+4.35*s,0.1*s);							// rear hand
}


void rjump (float s, int x, int y)	//guy bending at knee looking right
{
	rhead(s, x, y+50);											// head
	line(x,y+s+50,x,y+30+3.5*s);	   						// body
	line(x,y+30+3.5*s,x+s,y+4.5*s);							// front thigh
	line(x+s,y+4.5*s,x+1.3*s,y+5.5*s);                 // front shin
	line(x+1.25*s,y+5.5*s,x+1.79*s,y+5.4*s);				// front foot
	line(x,y+30+3.5*s,x-0.9*s,y+10+4.5*s);	   	  		// rear thigh
	line(x-0.9*s,y+10+4.5*s,x-1.25*s,y+5.35*s); 			// rear shin
	line(x-1.25*s,y+5.35*s,x-1.75*s,y+5.55*s); 			// rear foot
	line(x,y+50+1.4*s,x+1.5*s,y+3.65*s);					// front arm
	circle(x+1.56*s,y+3.73*s,0.1*s);  						// front hand
	line(x,y+50+1.4*s,x-0.75*s,y+4*s);	   				// rear arm
	circle(x-0.78*s,y+4.08*s,0.1*s);		   				// rear hand
}


void ljump (float s, int x, int y)	//guy bending at knee looking left
{
	lhead(s, x, y+50);											// head
	line(x,y+s+50,x,y+30+3.5*s);								// body
	line(x,y+30+3.5*s,x-s,y+4.5*s);							// front thigh
	line(x-s,y+4.5*s,x-1.3*s,y+5.5*s);                 // front shin
	line(x-1.25*s,y+5.5*s,x-1.79*s,y+5.4*s);				// front foot
	line(x,y+30+3.5*s,x+0.9*s,y+10+4.5*s);	   	  		// rear thigh
	line(x+0.9*s,y+10+4.5*s,x+1.25*s,y+5.35*s); 			// rear shin
	line(x+1.25*s,y+5.35*s,x+1.75*s,y+5.55*s); 			// rear foot
	line(x,y+50+1.4*s,x-1.5*s,y+3.65*s); 					// front arm
	circle(x-1.56*s,y+3.73*s,0.1*s);							// front hand
	line(x,y+50+1.4*s,x+0.75*s,y+4*s);	 					// rear arm
	circle(x+0.78*s,y+4.08*s,0.1*s);							// rear hand
}


void walkright(float s, int x, int y)	//guy walking right, starting from
													//position x  --  once right side
													//of screen is reached, function ends
{

while (!kbhit())
	{
		x=x+50;
		setcolor(WHITE);
		rstride(s, x, y);
		setcolor(BLACK);
		rstride(s, x, y);
		x=x+50;
		setcolor(WHITE);
		rmidwalk(s, x, y);
		setcolor(BLACK);
		rmidwalk(s, x, y);
		xpos=x;           	//puts x position into global int 'xpos' so
									//other functions (jumping,turning,etc) know
									//where the stick figure is (when stopped)

		dir='r';					//puts direction of stick figure into global
									//char 'walk' so other functions know what
									//direction the stick figure is facing

		walk='t';				//puts t(true) into global char 'walk' so other
									//functions know whether or not the stick figure
									//is in motion -- (for turning and jumping)
		if (x>640) break;    //ends function when right edge is reached
	}
}


void walkleft(float s, int x, int y)	//guy walking right, starting from
													//position x  --  once right side
													//of screen is reached, function ends
{

while (!kbhit())
	{
		x=x-50;
		setcolor(WHITE);
		lstride(s, x, y);
		setcolor(BLACK);
		lstride(s, x, y);
		x=x-50;
		setcolor(WHITE);
		lmidwalk(s, x, y);
		setcolor(BLACK);
		lmidwalk(s, x, y);
		xpos=x;              //see comments for function 'walkright'
		dir='l';
		walk='t';
		if (x<0) break;      //ends function when left edge is reached
	}
}

void rmove(float s)
{
	while (!kbhit())            //rmove and lmove (below) are called after
	{                           //either edge of screen are reached
		walkright(s,0,200);		 //they continue to loop until any key
		walkleft(s,640,200);	 	 //is pressed
	}
}


void lmove(float s)
{
	while (!kbhit())
	{
		walkleft(s,640,200);
		walkright(s,0,200);
	}
}


void main ()
{

int driver, mode;

driver = DETECT;										// set to best graphics mode
initgraph(&driver, &mode, "");  					// path for graphics files

setlinestyle(SOLID_LINE, 0, THICK_WIDTH);
setfillstyle(EMPTY_FILL, 0);

sleep(1);   				//pause for a sec to let the video mode change before
								//displaying anything

cout << "(W) Walk    (T) Turn    (S) Stop    (J) Jump    (A) Move Away"
	  << "	(N) Move Nearer";

									  //menu bar ^^^ top line

setcolor(WHITE);
rstride(size, xpos, 200);    //put up a starting point for the stick figure


while(99)						  //keeps looping until a key other than
									  //w,W,t,T,s,S,j,J,a,A,n,N is pressed
{
	switch(key=getch())  	  //reads in keypress
	{

		case 'w':			//walk
				{
					if (dir=='l')         		 //if stick figure is pointing left
					 {
						setcolor(BLACK);
						lstride(size,xpos,200);  //erase what was onscreen before
						setcolor(WHITE);
						walkleft(size,xpos,200); //and start walking left -- this
						rmove(size);				 //breaks, and starts r->l->r...
					 }									 //loop, until keypress

					else if (dir=='r')
					 {                			 //same thing -- facing right
						setcolor(BLACK);
						rstride(size,xpos,200);
						setcolor(WHITE);
						walkright(size,xpos,200);
						lmove(size);
					 }

					break;
				}


		case 's':			//stop
				{
					if (dir=='l')              //if facing left, 's' will stop
					 {									//walking loop (keypress) and redraw
						setcolor(WHITE);        //stick figure where he was stopped
						lstride(size,xpos,200);
					 }
					else if (dir=='r')
					 {                         //same thing -- facing right
						setcolor(WHITE);
						rstride(size,xpos,200);
					 }

					walk='f';                  //sets 'walk' flag to false so other
														//functions know not to start stick
					break;							//figure in motion after that
				}										//function is complete


		case 't':			//turn around
				{
					if (dir=='l')              //if direction is left, change flag
					 {                         //to say right
						dir='r';
						setcolor(BLACK);        //erase old location
						lstride(size,xpos,200);
						setcolor(WHITE);        //draw new one -- opposite direction
						rstride(size,xpos,200);
							if (walk=='t')       //if stick figure is in motion
							{
								setcolor(BLACK);
								rstride(size,xpos,200);
								setcolor(WHITE);           //do the same thing and
								walkright(size,xpos,200);  //make him continue moving
								lmove(size);
							}
					 }

					else if (dir=='r')
					 {
						dir='l';
						setcolor(BLACK);
						rstride(size,xpos,200);
						setcolor(WHITE);
						lstride(size,xpos,200);         //same as above
							if (walk=='t')               //opposite direction
							{
								setcolor(BLACK);
								lstride(size,xpos,200);
								setcolor(WHITE);
								walkleft(size,xpos,200);
								rmove(size);
							}
					 }

					break;
				}


		case 'j':         //jump
				{
					if (dir=='r')              //if direction is right
					 {                         //erase the right facing frame of
						setcolor(BLACK);			//stick figure
						rstride(size,xpos,200);
						setcolor(WHITE);
						rjump(size,xpos,200);  	//call 'rjump' to draw new frame of
						setcolor(BLACK);			//guy bending at knees
						rjump(size,xpos,200);
						setcolor(WHITE);
						rstride(size,xpos,150); //erase it, move up, draw new frame
						setcolor(BLACK);        //erase, etc...
						rstride(size,xpos,150);
						setcolor(WHITE);
						rmidwalk(size,xpos,100);
						setcolor(BLACK);
						rmidwalk(size,xpos,100);
						setcolor(WHITE);
						rstride(size,xpos,150);
						setcolor(BLACK);
						rstride(size,xpos,150);
						setcolor(WHITE);
						rjump(size,xpos,200);
						setcolor(BLACK);
						rjump(size,xpos,200);
						setcolor(WHITE);
						rstride(size,xpos,200);
							if (walk=='t')         //if guy was in motion, the above
							 {                     //is done and stick fig continues
								setcolor(BLACK);    //moving in direction he was going
								rstride(size,xpos,200);
								setcolor(WHITE);
								walkright(size,xpos,200);
								lmove(size);
							 }
					 }

					else if (dir=='l')               //same as above
					 {                               //opposite direction
						setcolor(BLACK);
						lstride(size,xpos,200);
						setcolor(WHITE);
						ljump(size,xpos,200);
						setcolor(BLACK);
						ljump(size,xpos,200);
						setcolor(WHITE);
						lstride(size,xpos,150);
						setcolor(BLACK);
						lstride(size,xpos,150);
						setcolor(WHITE);
						lmidwalk(size,xpos,100);
						setcolor(BLACK);
						lmidwalk(size,xpos,100);
						setcolor(WHITE);
						lstride(size,xpos,150);
						setcolor(BLACK);
						lstride(size,xpos,150);
						setcolor(WHITE);
						ljump(size,xpos,200);
						setcolor(BLACK);
						ljump(size,xpos,200);
						setcolor(WHITE);
						lstride(size,xpos,200);
							if (walk=='t')           //if moving, keep doing so
							 {								 //after jump..
								setcolor(BLACK);
								lstride(size,xpos,200);
								setcolor(WHITE);
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }

					break;
			}


		case 'a':         //move away
				{
					if ((walk=='t')&&(size>=14))        //only shrink if size is 14
					 {                                  //or greater and stick fig
																	//is in motion.. (walk=='t')
							if (dir=='r')             		//if guy is facing right,
							 {
								setcolor(BLACK);	  			//erase what is onscreen,
								rstride(size,xpos,200);
								setcolor(WHITE);
								size=size-3;              	//shrink size by 3
								walkright(size,xpos,200);  //walking sequence continues
								lmove(size);               //and repeats until next key
							 }

							else if (dir=='l')            //same as above
							 {
								setcolor(BLACK);				//opposite direction
								lstride(size,xpos,200);
								setcolor(WHITE);
								size=size-3;
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }

					else                                //else if the size is <14,
					 {												//just continue walking in
							if ((walk=='t')&&(dir=='r'))	//same direction
							 {
								walkright(size,xpos,200);
								lmove(size);
							 }

							else if((walk=='t')&&(dir=='l'))
							 {
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }
					break;
				}


		case 'n':         //move nearer
				{
					if ((walk=='t')&&(size<=47))       //only grow if (size<=47)
					 {                                 //case 'n' is the same as
							 if (dir=='r')               //case 'a', except size of
							 {                           //stick figure is growing
								setcolor(BLACK);          //here..  size=size+3
								rstride(size,xpos,200);
								setcolor(WHITE);
								size=size+3;
								walkright(size,xpos,200);
								lmove(size);
							 }

							 else if (dir=='l')
							 {
								setcolor(BLACK);
								lstride(size,xpos,200);
								setcolor(WHITE);
								size=size+3;
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }
					else											//else if the size is >47,
					 {												//just continue walking in
							if ((walk=='t')&&(dir=='r'))	//same direction
							 {
								walkright(size,xpos,200);
								lmove(size);
							 }

							else if((walk=='t')&&(dir=='l'))
							 {
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }
					break;
				}


//ALL cases below are the SAME AS ABOVE only allow for capital letters as
//input.. in case user has caps lock key on or something..


		case 'W':
				{
					if (dir=='l')
					 {
						setcolor(BLACK);
						lstride(size,xpos,200);
						setcolor(WHITE);
						walkleft(size,xpos,200);
						rmove(size);
					 }

					else if (dir=='r')
					 {
						setcolor(BLACK);
						rstride(size,xpos,200);
						setcolor(WHITE);
						walkright(size,xpos,200);
						lmove(size);
					 }

					break;
				}


		case 'S':			//stop
				{
					if (dir=='l')
					 {
						setcolor(WHITE);
						lstride(size,xpos,200);
					 }
					else if (dir=='r')
					 {
						setcolor(WHITE);
						rstride(size,xpos,200);
					 }

					walk='f';

					break;
				}


		case 'T':			//turn around
				{
					if (dir=='l')
					 {
						dir='r';
						setcolor(BLACK);
						lstride(size,xpos,200);
						setcolor(WHITE);
						rstride(size,xpos,200);
							if (walk=='t')
							{
								setcolor(BLACK);
								rstride(size,xpos,200);
								setcolor(WHITE);
								walkright(size,xpos,200);
								lmove(size);
							}
					 }

					else if (dir=='r')
					 {
						dir='l';
						setcolor(BLACK);
						rstride(size,xpos,200);
						setcolor(WHITE);
						lstride(size,xpos,200);
							if (walk=='t')
							{
								setcolor(BLACK);
								lstride(size,xpos,200);
								setcolor(WHITE);
								walkleft(size,xpos,200);
								rmove(size);
							}
					 }

					break;
				}


		case 'J':         //jump
				{
					if (dir=='r')
					 {
						setcolor(BLACK);
						rstride(size,xpos,200);
						setcolor(WHITE);
						rjump(size,xpos,200);
						setcolor(BLACK);
						rjump(size,xpos,200);
						setcolor(WHITE);
						rstride(size,xpos,150);
						setcolor(BLACK);
						rstride(size,xpos,150);
						setcolor(WHITE);
						rmidwalk(size,xpos,100);
						setcolor(BLACK);
						rmidwalk(size,xpos,100);
						setcolor(WHITE);
						rstride(size,xpos,150);
						setcolor(BLACK);
						rstride(size,xpos,150);
						setcolor(WHITE);
						rjump(size,xpos,200);
						setcolor(BLACK);
						rjump(size,xpos,200);
						setcolor(WHITE);
						rstride(size,xpos,200);
							if (walk=='t')
							 {
								setcolor(BLACK);
								rstride(size,xpos,200);
								setcolor(WHITE);
								walkright(size,xpos,200);
								lmove(size);
							 }
					 }

					else if (dir=='l')
					 {
						setcolor(BLACK);
						lstride(size,xpos,200);
						setcolor(WHITE);
						ljump(size,xpos,200);
						setcolor(BLACK);
						ljump(size,xpos,200);
						setcolor(WHITE);
						lstride(size,xpos,150);
						setcolor(BLACK);
						lstride(size,xpos,150);
						setcolor(WHITE);
						lmidwalk(size,xpos,100);
						setcolor(BLACK);
						lmidwalk(size,xpos,100);
						setcolor(WHITE);
						lstride(size,xpos,150);
						setcolor(BLACK);
						lstride(size,xpos,150);
						setcolor(WHITE);
						ljump(size,xpos,200);
						setcolor(BLACK);
						ljump(size,xpos,200);
						setcolor(WHITE);
						lstride(size,xpos,200);
							if (walk=='t')
							 {
								setcolor(BLACK);
								lstride(size,xpos,200);
								setcolor(WHITE);
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }

					break;
			}


		case 'A':         //move away
				{
					if ((walk=='t')&&(size>=14))
					 {

							if (dir=='r')
							 {
								setcolor(BLACK);
								rstride(size,xpos,200);
								setcolor(WHITE);
								size=size-3;
								walkright(size,xpos,200);
								lmove(size);
							 }

							else if (dir=='l')
							 {
								setcolor(BLACK);
								lstride(size,xpos,200);
								setcolor(WHITE);
								size=size-3;
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }

					else
					 {
							if ((walk=='t')&&(dir=='r'))
							 {
								walkright(size,xpos,200);
								lmove(size);
							 }

							else if((walk=='t')&&(dir=='l'))
							 {
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }
					break;
				}


		case 'N':         //move nearer
				{
					if ((walk=='t')&&(size<=47))
					 {
							 if (dir=='r')
							 {
								setcolor(BLACK);
								rstride(size,xpos,200);
								setcolor(WHITE);
								size=size+3;
								walkright(size,xpos,200);
								lmove(size);
							 }

							 else if (dir=='l')
							 {
								setcolor(BLACK);
								lstride(size,xpos,200);
								setcolor(WHITE);
								size=size+3;
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }
					else
					 {
							if ((walk=='t')&&(dir=='r'))
							 {
								walkright(size,xpos,200);
								lmove(size);
							 }

							else if((walk=='t')&&(dir=='l'))
							 {
								walkleft(size,xpos,200);
								rmove(size);
							 }
					 }
					break;
				}


		default:     //if anything other than the above keys are pressed
		  {
			closegraph();     //close graphics mode
			return;	 			//end program
		  }

	 } //end switch(key=getch())

  } //end while(99)

} //end main
