// ColourWindow.cpp : implementation file
//

#include "stdafx.h"
#include "pablodraw.h"
#include "PreviewWindow.h"
#include "MainFrm.h"

/////////////////////////////////////////////////////////////////////////////
// CPreviewWindow

CPreviewWindow::CPreviewWindow()
{
    m_bFloatVert = FALSE;
    m_pCanvasView = NULL;
}

CPreviewWindow::~CPreviewWindow()
{
}


BEGIN_MESSAGE_MAP(CPreviewWindow, CSizingControlBarG)
    ON_WM_CREATE()
    ON_WM_SIZE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPreviewWindow message handlers


int CPreviewWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CSizingControlBarG::OnCreate(lpCreateStruct) == -1)
        return -1;

    return 0;
}
BOOL CPreviewWindow::SetParentFrame(CMainFrame* p_pParentFrame)
{
    if (!m_pCanvasView)
	{
	    CRect rect;
		GetClientRect(rect);
	    m_pCanvasView = new CCanvasView();
		m_pCanvasView->SetPreview(TRUE);
		m_pCanvasView->Create(NULL, NULL, WS_CHILD|WS_VISIBLE, rect, this, 1);
		p_pParentFrame->GetDocument()->AddView(m_pCanvasView);
		m_pCanvasView->OnInitialUpdate();
//		m_pCanvasView->SetActiveWindow();
		m_pCanvasView->ScaleFont(2);
	}

//	m_pCanvasView->m_pDocument = p_pParentFrame->GetActiveDocument();
	//m_pCanvasView->SetParentFrame(p_pParentFrame);

    return TRUE;
}


void CPreviewWindow::OnSize(UINT nType, int cx, int cy) 
{
    CSizingControlBarG::OnSize(nType, cx, cy);
    if (m_pCanvasView)
    {
        m_pCanvasView->MoveWindow(0,0,cx,cy);
    }
}
BOOL CPreviewWindow::UpdateFixedSizes(BOOL bHorz, BOOL bDocked)
{
	if (m_pCanvasView)
	{
		CSize size;
		m_pCanvasView->GetScrollSize(size);

		m_szFixed.cx = size.cx;
		if (!g_bFullScreen) m_szFixed.cx += GetSystemMetrics(SM_CXVSCROLL) + 4;
	}
    return CSizingControlBarG::UpdateFixedSizes(bHorz, bDocked);

}

CSize CPreviewWindow::CalcDynamicLayout(int nLength, DWORD dwMode)
{
    //dwMode &= ~LM_STRETCH;

    return CSizingControlBarG::CalcDynamicLayout(nLength, dwMode);
}



BOOL CPreviewWindow::PreTranslateMessage(MSG* pMsg)
{
	//if (m_pCanvasView && m_pCanvasView->PreTranslateMessage(pMsg)) return TRUE;

	return CWnd::PreTranslateMessage(pMsg);
}
