// ListeningSocket.h: interface for the CListeningSocket class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LISTENINGSOCKET_H__DE547881_6125_4C3A_905C_9EAF589AA9B5__INCLUDED_)
#define AFX_LISTENINGSOCKET_H__DE547881_6125_4C3A_905C_9EAF589AA9B5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ServingSocket.h"
#include "ServingSocketThread.h"
class CPabloDrawDoc;

class CServingSocketThread;

class CListeningSocket : public CSocket
{
    friend class CServingSocket;
	DECLARE_DYNAMIC(CListeningSocket);
public:
    CListeningSocket(CPabloDrawDoc* pDoc);
	virtual ~CListeningSocket();

    void DisconnectAll(CEvent* p_pev);

    void Write(const void* pBuf, UINT uiSize, CServingSocket* pSource = NULL);
    void Writeul(ULONG ulValue, CServingSocket* pSource = NULL);
    void Writeus(USHORT usValue, CServingSocket* pSource = NULL);
    void Writeuc(UCHAR ucValue, CServingSocket* pSource = NULL);
    void WriteRc(LPRECT rect, CServingSocket* pSource = NULL);
    void WriteSz(LPSIZE size, CServingSocket* pSource = NULL);
    void WritePt(LPPOINT point, CServingSocket* pSource = NULL);
	void SendPart(cCanvas* pCanvas, CRect rect, CPoint ptDest, CServingSocket* pSource = NULL);

    void FlushAll(CServingSocket* pSource = NULL);

	void GetAliasList(CStringList& p_sl, CServingSocket* pSource);
    void RemoveSocket(CServingSocketThread* pSocketThread, BOOL p_bLock = TRUE);
    void AddSocket(CServingSocketThread* pSocketThread);

	int GetNumUsers() const { return m_connectionList.GetCount(); }

	inline CPabloDrawDoc* GetDocument() { return m_pDoc; }

    CPtrList m_connectionList;
	CMutex			m_mutex;

protected:
	virtual void OnAccept(int nErrorCode);

protected:
    CPabloDrawDoc* m_pDoc;

    CEvent* m_pev;
};

#endif // !defined(AFX_LISTENINGSOCKET_H__DE547881_6125_4C3A_905C_9EAF589AA9B5__INCLUDED_)
