Unit LoadFile;

Interface

Uses
  records,
  xms_,
  crt,
  dos,
  control,
  extense,
  genShit,
  skaUnit,
  stm,
  sauceU,
  sort;

{:FUNCTION DEFINITIONS:::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Function  eLoadFileMenu : boolean;
Function  eValidSauce (FN: String) : Boolean;
Procedure eLoadAnsi   (fileName : string; width : word; maxLines : longint; var lines : longint; findaSig : boolean);
Procedure eLoadBin    (fileName : string);
Procedure eLoadAdf    (fileName : string);
Procedure eLoadXBin   (fileName : string);
Procedure eLoadPipe   (fileName : string);
Procedure eLoadPal    (fileName : string);
Procedure eLoadFont   (FN: String);
Procedure eLoadFile   (FN: String);

{:PUBLIC VARIABLES:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Var
 eLastPos   : LongInt;
 eLastFirst : LongInt;
 eLastFile  : LongInt;
 eMask      : String;

{:PRIVATE VARIABLES::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Implementation

Procedure eFileScrn; External; {$L .\ART\FILESECT.OBJ}

Type
  eFileRec = Record
    FileName : String[12];
    FileType : Byte;          {0=directory, 1=file, 2=drive}
  End;

Var
  eFileData : eFileRec;
  eTtlFiles : Word;
  eBuffFile : File;
  eSaucePos : LongInt;

{:FUNCTIONS:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Function IsDriveValid (dLetter: Char): Boolean;
Var
  Regs: Dos.Registers;
Begin
  IsDriveValid := False;

  If Not (UpCase(dLetter) in ['A'..'Z']) Then Exit;

  Regs.BX := Ord(UpCase(dLetter)) - Ord('A') + 1;
  Regs.AX := $4409;

  Intr($21, Regs);

  If (Regs.AX And FCarry) = FCarry Then Exit;

  IsDriveValid := True;
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadFile (FN: String);
Var
  Ext : String[3];
Begin
  If Not FileExist(FN) Then Exit;

  eSetResolution;

  If Pos('.', FN) = 0 Then
    Ext := ''
  Else
    Ext := UpperCase(Copy(FN, Pos('.', FN) + 1, Length(FN) - Pos('.', FN) + 1));

  eValidSauce(FN);

  eCurrentData^.CurXBIN := False;

  If Ext = eConfigData^.cAnsiExt Then eLoadAnsi(FN, 80, eMaxLines, eCurrentData^.curLength, False) Else
  If Ext = eConfigData^.cAdfExt  Then eLoadAdf(FN)  Else
  If Ext = eConfigData^.cXBinExt Then eLoadXBin(FN) Else
  If Ext = eConfigData^.cBinExt  Then eLoadBin(FN)  Else
  If Ext = eConfigData^.cPipExt  Then eLoadPipe(FN) Else
  If Ext = eConfigData^.cPalExt  Then eLoadPal(FN)  Else
  If Ext = eConfigData^.cFontExt Then eLoadFont(FN) Else
    eLoadAnsi(FN, 80, eMaxLines, eCurrentData^.CurLength, False);
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eInitDataBase (Init: Boolean);
Var
  FileList   : SearchRec;
  Drive      : Char;
  Sort       : PQuickSort;
  Count      : LongInt;
Begin
  If Not Init Then Begin
    Close  (eBuffFile);
    Assign (eBuffFile, eStartDir + 'EMPATHY.SWP');
    Erase  (eBuffFile);
    Exit;
  End;

  Assign  (eBuffFile, eStartDir + 'EMPATHY.SWP');
  ReWrite (eBuffFile, 1);

  eTtlFiles := 0;
  FillChar(eFileData, SizeOf(eFileData), 0);

  For Drive := 'A' to 'Z' Do
    If IsDriveValid(Drive) Then Begin
      Inc (eTtlFiles);
      eFileData.FileName := '[' + Drive + ':\]';
      eFileData.FileType := 2;
      BlockWrite (eBuffFile, eFileData, SizeOf(eFileData));
    End;

{ Create and Sort list of directories }

  Sort := New(PQuickSort, Init);

  FindFirst('*.', Directory, FileList);
  While DosError = 0 Do Begin
    If DirExist(FileList.Name) Then
      Sort^.Add(FileList.Name, 0);

    FindNext(FileList);
  End;

  Sort^.Sort(1, Sort^.Total, qAscending);

  For Count := 1 to Sort^.Total Do Begin
    Inc(eTtlFiles);
    eFileData.FileName := Sort^.Data[Count]^.Name;
    eFileData.FileType := 0;
    BlockWrite (eBuffFile, eFileData, SizeOf(eFileData));
  End;

  Sort^.Clear;

{ Create and Sort list of file names }

  FindFirst(eMask, Archive, FileList);
  While DosError = 0 Do Begin
    If
      (UpperCase(FileList.Name) <> 'EMPATHY.EXE') And
      (UpperCase(FileList.Name) <> 'EMPATHY.DAT') And
      (UpperCase(FileList.Name) <> 'EMPATHY.SWP') And
      (Pos('EMP.PAG', UpperCase(FileList.Name)) = 0)
    Then
      Sort^.Add(FileList.Name, 0);

    FindNext(FileList);
  End;

  Sort^.Sort (1, Sort^.Total, qAscending);

  For Count := 1 to Sort^.Total Do Begin
    Inc(eTtlFiles);
    eFileData.FileName := Sort^.Data[Count]^.Name;
    eFileData.FileType := 1;
    BlockWrite(eBuffFile, eFileData, SizeOf(eFileData));
  End;

  Dispose (Sort, Done);
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadFileData (Num: Word);
Begin
  Seek      (eBuffFile, Pred(Num) * SizeOf(eFileData));
  BlockRead (eBuffFile, eFileData, SizeOf(eFileData));
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Function eLoadFileMenu : boolean;
var x : word;
  pos : byte;
first : word;
  key : string[2];
 done : boolean;
 clear: boolean;
 inStr: string;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
        Procedure eEliteWrite(str : string);
        var eCount : byte;
         begin
         for eCount := 1 to length(str) do
          if (str[eCount]='I') then str[eCount] := 'i';
         write(str);
         end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
        Procedure eShowFileType;
        var eExt  : string[3];
            eType : string[8];
         begin
         gotoXY(11,18);
         eLoadFileData(x);
         if (system.pos('.',eFileData.fileName)=0) then eExt := '' else
          eExt := copy(eFileData.fileName,(system.pos('.',eFileData.fileName)+1),(length(eFileData.fileName)-
           system.pos('.',eFileData.fileName)+1));
         eExt := upperCase(eExt);
         if (eFileData.fileType=1) then begin
         if (eExt=eConfigData^.cAnsiExt) then eType := 'Ansi' else
         if (eExt='ASC') then eType := 'Ascii' else
         if (eExt='TXT') then eType := 'Ascii' else
         if (eExt='NFO') then eType := 'iNFO'  else
         if (eExt=eConfigData^.cXbinExt)   then eType := 'XBiN' else
         if (eExt=eConfigData^.cAdfExt)    then eType := 'Artworx' else
         if (eExt=eConfigData^.cBinExt)    then eType := 'Binary' else
         if (eExt=eConfigData^.cFontExt)   then eType := 'Font' else
         if (eExt=eConfigData^.cPalExt)    then eType := 'Palette' else
         if (eExt=eConfigData^.cPascalExt) then eType := 'Pascal' else
         if (eExt=eConfigData^.cCppExt)    then eType := 'C/C++' else
         if (eExt=eConfigData^.cPipExt)    then eType := 'Pipe' else
             eType := 'Unknown';
         end else eType := 'N/A';
         skaWrite('|B0|11'+eTab(eType,8));
         end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
        Procedure eShowDirect;
         begin
         cursor_on;
         textAttr := 7;
         gotoXY(21,20);
         eEliteWrite(eTab(inStr,44));
         gotoXY(21+length(inStr),20);
         end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
        Procedure eDoClear;
        var c : word;
            b : array[1..43*2] of byte;
         begin
         move(@eFileScrn^,mem[$b800:0],4000);
         fillChar(b,sizeOf(b),0);
         for c := 1 to 14 do
         move(b,mem[$b800:((c+5)*160)+40],sizeOf(b));
         eShowDirect;
         end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
        Procedure eShowBars;
        var count : word;
         begin
         cursor_off;
         if (eTtlFiles-first+1>42) then
          begin
          for count := first to first+41 do
           begin
           if (count-first+1 in [1..14] ) then gotoXY(20,count-first+5) else
           if (count-first+1 in [14..28]) then gotoXY(35,count-first-14+5) else
           if (count-first+1 in [29..42]) then gotoXY(50,count-first-28+5);
           eLoadFileData(count);

           if (count=x) then
             textAttr := 3*16
           else
             Case eFileData.FileType of
               0 : TextAttr := 8;
               1 : TextAttr := 7;
               2 : TextAttr := 9;
             End;

           eEliteWrite(eTab(eFileData.fileName,13));
           end;
          end else
           begin
           textAttr := 7;
           if (clear=true) then begin eDoClear; clear := false; end;
           for count := first to eTtlFiles do
           begin
           if (count-first+1 in [1..14] ) then gotoXY(20,count-first+5) else
           if (count-first+1 in [14..28]) then gotoXY(35,count-first-14+5) else
           if (count-first+1 in [29..42]) then gotoXY(50,count-first-28+5);
           eLoadFileData(count);

           if (count=x) then
             textAttr := 3*16
           else
             Case eFileData.FileType of
               0 : TextAttr := 8;
               1 : TextAttr := 7;
               2 : TextAttr := 9;
             End;

           eEliteWrite(eTab(eFileData.fileName,13));
           end;
          end;
         eLoadFileData(x);

         Case eFileData.FileType of
           0 : inStr := '<DiSK DiRECTORY>';
           1 : inStr := eFileData.FileName;
           2 : inStr := '<DiSK DRiVE>';
         End;

         eShowFileType;
         eShowDirect;
{         gotoxy(1,1);writeLn('pos = ',pos,' -- first = ',first,' -- x = ',x,'     ');}
         end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

  Procedure eDoKeyFunc (Num: Byte);
  Begin
    Case Num of
      1 : Begin
            if (pos<>1) then begin
              dec(x);
              dec(pos);
            end else
            if (pos=1) and (first>1) then begin
              clear := true;
              dec(first,14);
              dec(x);
              pos := 14;
            end;
            eShowBars;
          End;
      2 : Begin
            if (pos<>42) and (x+1<=eTtlFiles) then begin
              inc(x);
              inc(pos);
            end else
            if (pos=42) and (x+1<=eTtlFiles) then begin
              clear := true;
              inc(first,14);
              inc(x);
              pos := 29;
            end;
            eShowBars;
          End;
      3 : Begin
            if (pos in [29..42]) and (x+14<=eTtlFiles) then begin
              inc(x,14);
              inc(first,14);
              clear := true;
            end else
            if (pos in [29..42]) and (x+(42-pos)+1<=eTtlFiles) then begin
              inc(x,(42-pos)+1);
              pos := 29;
              inc(first,14);
              clear := true;
            end else
            if (pos in [1..28]) and (x+14<=eTtlFiles) then begin
              inc(x,14);
              inc(pos,14);
            end;
            eShowBars;
          End;
      4 : Begin
            if (pos in [1..14]) and (first>=15) then begin
              dec(first,14);
              dec(x,14);
              clear := true;
            end else
            if (pos in [15..42]) then begin
              dec(x,14);
              dec(pos,14);
            end;
            eShowBars;
          End;
      5 : Begin
            X     := 1;
            Pos   := 1;
            First := 1;
            Clear := True;

            eShowBars;
          End;
    End;
  End;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
        Procedure eDoEnter;
        var eTmpStr  : string;
            eTmpDRec : searchRec;
            eCount   : byte;
            eClip    : boolean;
         begin

{make this accept directory names in the input field.. that would make it
very elite...}

          eClip := false;
          if (length(inStr)=0) or (inStr='<DiSK DiRECTORY>') or (inStr='<DiSK DRiVE>') then begin
            eLoadFileData(x);

            if (eFileData.fileType=1) then begin
              eLoadFile(eFileData.fileName);
              done := true;
              eLoadFileMenu := true;
            end else begin
              If efiledata.filetype = 2 Then Begin
                GetDIR(0, eTmpStr);
                {$I-} chDir(Copy(eFileData.FileName, 2, 3)); {$I+}
                If IoResult <> 0 Then chDir(eTmpStr);
              End Else
                chDir(eFileData.fileName);

              close(eBuffFile);
              eInitDataBase(true);
              x     := 1;
              pos   := 1;
              first := 1;
              clear := true;
              eShowBars;
            end;
          end else
          if (fileExist(inStr)=true) then begin
            eLoadFile(inStr);
            done := true;
            eLoadFileMenu := true;
          end else
          if ((system.pos('*',inStr)>0) or (inStr[length(inStr)]='.')) then begin
             if (inStr[length(inStr)]='.') then begin
               eClip := true;
               inStr := inStr+'\*.*';
             end;
             findFirst(inStr,archive,eTmpDRec);
             if (dosError=0) then begin
               if (system.pos('\',inStr)>0) then begin
                 eTmpStr := inStr;
                 while (eTmpStr[length(eTmpStr)]<>'\') do dec(eTmpStr[0]);
                 if eClip then eTmpStr[0] := char(length(eTmpStr)-1);
                 if (dirExist(eTmpStr)=true) then chDir(eTmpStr);
                 eCount := length(eTmpStr)+1;
               end else
                 eCount := 1;

               if (eClip=true) then
                 eMask := '*.*'
               else
                 eMask := copy(inStr,eCount,length(inStr)-pred(eCount));

               eInitDataBase(false);
               eInitDataBase(true);
               move(@eFileScrn^,mem[$b800:0000],4000);
               x     := 1;
               pos   := 1;
               first := 1;
               eShowBars;
             end else inStr := '';
          end else inStr := '';
          eShowDirect;
        end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Begin
  eMask := '*.*';
  eInitDataBase(true);
  if (eCurrentData^.curRes<>1) then textMode(3);
  window(1,2,80,25);
  move(@eFileScrn^,mem[$b800:0000],4000);
  x     := eLastFile;
  pos   := eLastPos;
  first := eLastFirst;
  cursor_off;
  eShowBars;
  fillChar(inStr,sizeOf(inStr),0);
  repeat
    if (pos<1)  then pos := 1;
    if (pos>42) then pos := 42;
    if (x>eTtlFiles) then x := eTtlFiles;
    if (x<1) then x := 1;

    repeat key := eReadKey until (key<>'no');    { kill the "none" }

    if eMouseUsed then
      case key[1] of
        'Q' : done := true;
        'B' : eDoEnter;
        '8' : eDoKeyFunc(1);
        '2' : eDoKeyFunc(2);
        '6' : eDoKeyFunc(3);
        '4' : eDoKeyFunc(4);
      end
    else
      case key[1] of
        #27 : done := true;
        #8  : begin
                if (inStr='<DiSK DiRECTORY>') or (inStr='<DiSK DRiVE>') then
                  inStr[0] := #0
                else begin
                  eLoadFileData(x);
                  if ((inStr<>eFileData.fileName) and (ord(inStr[0])>0)) then dec(inStr[0]) else
                  if (inStr=eFileData.fileName) then inStr[0] := #0;
                end;
                eShowDirect;
              end;
       #32..
       #255 : begin
                if (inStr='<DiSK DiRECTORY>') or (inStr='<DiSK DRiVE>') then
                  inStr[0] := #0;

                if (length(inStr)<44) then begin
                  inStr := inStr+key;
                  eShowDirect;
                end;
              end;
        #13 : eDoEnter;
        #0  : begin
                key := eReadKey;
                case key[1] of
                  #72 : eDoKeyFunc(1);
                  #80 : eDoKeyFunc(2);
                  #77,
                  #81 : eDoKeyFunc(3);
                  #73,
                  #75 : eDoKeyFunc(4);
                  #71 : eDoKeyFunc(5);
                end;
              end;
      end;

    if (eMouseUsed=true) then eMouseUsed := false;
  until (done=true);

  eClearMouse;
  cursor_on;
  eInitDataBase(false);
  textAttr   := 7;
  eLastFile  := x;
  eLastPos   := pos;
  eLastFirst := first;
end;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Function MaxL (L1, L2: LongInt) : LongInt;
Begin
  MaxL := Byte(L1 > L2) * L1 + Byte(Not(L1 > L2)) * L2;
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Function MinL (L1, L2: LongInt) : LongInt;
Begin
  MinL := Byte(L1 < L2) * L1 + Byte(Not(L1 < L2)) * L2;
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadAnsi(fileName : string; Width:word; MaxLines:longint; var Lines:longint;FindaSig : Boolean);
Type TParmRec = Record
                 B : Word;
                 S : String[3];
                End;
Var
 OldCurAttr : Byte;
 CurCh  : Char;
 F      : File;
 FindasigTripped : Boolean;
 Cntr2, BuffLen, BuffCntr, CurX, SavX:word; CurY, SavY : Longint;
 FSEState, CurAttr, CurParm : Byte;
 FileBuffer : Array[1..8192] of char;
 Parameter  : Array[1..10] of TParmRec;
 WidthCount : word;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure PutCharAttr(x:word; y:longint; Ch:char; Attr:byte);
Var Tmp:word;
  scPtr:longint;
Begin
 scPtr := (pred(Y)*eConfigData^.cWidth+pred(X))*2;
 Tmp := Word(Ch)+Word(Attr shl 8);
 xmsMoveDataTo(eXmsHandle,scPtr,2,@tmp);
End;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure DoColors;
Var Cntr : Byte;
    Fore,Back : Byte;
Begin
 If CurParm = 0 then exit;
 For Cntr := 1 to CurParm do
  Begin
   If FindasigTripped then
    Begin
     FindasigTripped := False;
     Curattr := OldCurAttr;
    End;
   Case Parameter[Cntr].b of
    0 :  CurAttr := $07;
    1 :  CurAttr:=CurAttr or $08;{asm or Attr, 08h end;}
    5 :  CurAttr:=CurAttr or $80;{asm or Attr, 80h end;}
    7 :  Asm
          mov  ax, word ptr CurAttr
          mov  bx, ax
          and  ax, 0707h
          xchg ah, al
          and  bx, 80h
          add  ax, bx
          mov  word ptr CurAttr, bx
         End;
   25 : CurAttr := (CurAttr AND (NOT $80)); {blink off}
   30 : CurAttr := (CurAttr AND $F8) + black;
   31 : CurAttr := (CurAttr AND $f8) + red;
   32 : CurAttr := (CurAttr AND $f8) + green;
   33 : CurAttr := (CurAttr AND $f8) + brown;
   34 : CurAttr := (CurAttr AND $f8) + blue;
   35 : CurAttr := (CurAttr AND $f8) + magenta;
   36 : CurAttr := (CurAttr AND $f8) + cyan;
   37 : CurAttr := (CurAttr AND $f8) + Lightgray;
   40 : CurAttr := (CurAttr AND $8F) + (black shl 4);
   41 : CurAttr := (CurAttr AND $8F) + (red shl 4);
   42 : CurAttr := (CurAttr AND $8F) + (green shl 4);
   43 : CurAttr := (CurAttr AND $8F) + (brown shl 4);
   44 : CurAttr := (CurAttr AND $8F) + (blue shl 4);
   45 : CurAttr := (CurAttr AND $8F) + (magenta shl 4);
   46 : CurAttr := (CurAttr AND $8F) + (cyan shl 4);
   47 : CurAttr := (CurAttr AND $8F) + (lightgray shl 4);
  End;
 If FindASig Then
  Begin
   {If (Lo(Textattr) = 0) and (Hi(TextAttr) = 0) then TextAttr := 15;}
    Fore := (CurAttr and $0f);
    Back := (CurAttr and $f0) shr 4;
{    Fore := CurAttr And $0F;
     Back := (CurAttr Shr 4) And $08;}
    If (Fore = 0) and (Back = 0) Then
     Begin
      OldCurattr := Curattr;
      CurAttr := 15;
      FindaSigTripped := True;
     End;
   End;
 End;
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure PutCh(CH : Char);
Begin
 Case CH of
  #8 : Begin
        If CurX > 1 then
         Begin
          Dec(CurX);
          PutCharAttr(CurX, CurY, ' ', CurAttr);
         End;
       End;
 #10 : If CurY < MaxLines then Inc(CurY);
 #13 : CurX:=1;
 #1..#7,#11,#14..#255:
       Begin
        PutCharAttr(CurX, CurY, Ch, CurAttr);
        Inc(CurX);
        If CurX > Width then
         Begin
          CurX := 1;
          If CurY < (MaxLines-1) then Inc(CurY);
         End;
       End;
 End; { Case }
 Lines:=MaxL(Lines, CurY);
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Begin
 eClearXms;
 FindAsigTripped := False;
 Assign(f,FileName);
 {$I-} Reset(f,1); {$I+}
 If IOResult<>0 then Exit;
 FSEState := 0;
 CurAttr  := 7;
 FillChar(Parameter, SizeOf(Parameter), 0);
 CurX := 1; CurY := 1; Lines := 0; SavX := 1; SavY := 1;
 Repeat
  BlockRead(f, FileBuffer, 4096, BuffLen);
  For BuffCntr := 1 to BuffLen do
   Begin
    CurCh := FileBuffer[BuffCntr];
    Case FSEState of
     0 : Case CurCh of
          #26 : begin close(f); Exit; end;
          #27 : inc(FSEState);
           #9 : if CurX<Width-8 then CurX:=((CurX div 8)+1)*8;
           else PutCh(CurCh);
         end;
     1 : Begin
          If CurCh='[' then
           begin
            inc(FSEState);
            CurParm:=0;
            Parameter[1].b := 0;
            Parameter[1].s := '';
           End else
           Begin
            PutCh(#27);
            PutCh('[');
            FSEState:=0;
           End;
         End;
     2 : Begin
          Case CurCh of
           '0'..'9','?','=','"' :
            Begin
             if CurParm=0 then CurParm:=1;
             Parameter[CurParm].s:=Parameter[CurParm].s+CurCh;
             if CurCh in ['0'..'9'] then Parameter[CurParm].b:=(Parameter[CurParm].b*10)+(ord(CurCh)-ord('0'))
                else begin
                      if CurParm<10 then inc(CurParm);
                      Parameter[CurParm].b:=0;
                      Parameter[CurParm].s[0]:=#0;
                     end;
            End;
           ';' : Begin
                  if CurParm < 10 then inc(CurParm);
                  Parameter[CurParm].b:=0;
                  Parameter[CurParm].s[0]:=#0;
                 End;
           'H','f': Begin
                     if CurParm>=1 then CurY:=MaxL(1,MinL(Parameter[1].b,MaxLines));
                     if CurParm>=2 then CurX:=MaxL(1,MinL(Parameter[2].b,Width));
                     FSEState:=0;
                    End;
           'A' : Begin
                  CurY:=MaxL(1,CurY-MaxL(1,Parameter[1].b));
                  FSEState:=0;
                 End;
           'B' : Begin
                  CurY:=MinL(CurY+MaxL(1,Parameter[1].b),MaxLines);
                  FSEState:=0;
                 End;
           'C' : Begin
                  CurX:=MinL(CurX+MaxL(1,Parameter[1].b),Width);
                  FSEState:=0;
                 End;
           'D' : Begin
                  CurX:=MaxL(1,CurX-MaxL(1,Parameter[1].b));
                  FSEState:=0;
                 End;
           'J' : Begin
                  Case Parameter[1].b of
                   0 : for Cntr2:=CurX to Width do PutCharAttr(Cntr2,CurY,' ', CurAttr);
                   1,2: begin
                         CurX:=1; CurY:=1;
                        End;
                  End;
                  FSEState:=0;
                 End;
           'K' : Begin
                  for Cntr2:=CurX to Width do PutCharAttr(Cntr2, CurY, ' ', CurAttr);
                  FSEState:=0;
                 end;
           'm' : Begin
                  DoColors;
                  FSEState:=0;
                 End;
           's' : Begin
                  SavX:=CurX;
                  SavY:=CurY;
                  FSEState:=0;
                 End;
           'u' : Begin
                  CurX:=SavX;
                  CurY:=SavY;
                  FSEState:=0;
                 End;
           'h' : FSEState:=0;
          End;
         End;
     End;
   End;
 Until (BuffLen<4096) or Eof(F);
 Close(f);
 asm mov ah, 1; mov cx, 2000h; int 10h; end;
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadBin (fileName : string);
var BFile : File;
    width : word;
    X : LongInt;
    TmpBuffer : Array[1..(999*2)] of Byte;
    Height   : LongInt;
    Size,Off : LongInt;
Begin
 eClearXms;
 window(1,1,80,25);
 clrScr;
 skaWrite('|15P|07lease |15e|07nter |15w|07idth |15o|07f |15b|07inary |15i|07mage: ');
 width := str2Byte(inputStr(whereX,whereY,7,3,'80'));
 width := width*2;
 if (width=0) then width := 160;
 Assign(BFile,fileName);
 Reset(BFile,1);
 height := Filesize(BFile) div width;
 eCurrentData^.curLength := height;
 For X := 0 to Height-1 do
 Begin
  Seek(Bfile,X*width);
  BlockRead(BFile,TmpBuffer,width);
  xmsMOVEDATATO(eXmsHandle,x*eConfigData^.cWidth*2,width,@tmpbuffer);
 End;
 Close(BFile);
end;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadAdf (fileName : string);
Var BFile : File;
    X        : Longint;
    width    : word;
    Version  : Byte;
    Count1   : Byte;
    TmpBuffer : Array[1..8192] of word;
    Height : LongInt;
Begin
 eClearXms;
 if (eCurrentData^.curRes>1) then
  begin
  textAttr := 7;
  gotoXY(1,1);
  skaWrite('|15A|07rtworx |15i|07mages |15c|07annot |15b|07e |15l|07oaded |15i|07n |0350 |15l|07ine |15m|07ode,'+
           '|15 w|07ould |15y|07ou |15l|07ike |15t|07o |15s|07witch |15m|07odes?');
  skaWrite('|15P|07lease |15e|07nter |15y|07our |15s|07election: ');
  if (eSel=false) then exit;
  end;
 eCurrentData^.curRes := 1;
 Assign(BFile,fileName);
 Reset(BFile,1);
 Height := (filesize(BFile)-4298) div 160; {calculate number of lines in picture}
 eCurrentData^.curLength := height;
 Blockread(BFile,Version,1);
 Blockread(BFile,eCurrentData^.curPal,SizeOf(eCurrentData^.curPal));
 Blockread(BFile,eCurrentData^.curFont,4096);
 For count1:=0 to 63 do
     eSetAdfPalette(count1,eCurrentData^.curPal[count1,1],eCurrentData^.curPal[count1,2],eCurrentData^.curPal[count1,3]);
 eSetAdfFont;
 asm mov ah, 1; mov cx, 2000h; int 10h; end;
 Seek(BFile,4289);
 width := 160;
 For X := 1 to Height do
  Begin
   BlockRead(BFile,TmpBuffer,width);
   xmsMoveDataTo(eXmsHandle,pred(x)*eConfigData^.cWidth*2,160,@tmpbuffer);
  End;
 Close(BFile);
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadXBin(fileName : string);
const ePaletteID : array[0..15] of byte = (0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);
var   eXBinFile  : stream;
      eBuffer    : array[0..(999*2)] of byte;
      eCount     : array[1..2] of longInt;
      eHeader    : eXBinRec;
      eTmpPal    : array[0..15,1..3] of byte;
      eCompressed: boolean;
      eCompCount : longint;
      counter    : byte;
      cType, i   : byte;
      char,attr  : byte;
      eXmsPos    : longInt;
      eCurPage   : word;
      eHasSauce  : boolean;
      eFileEnd   : longint;

      Procedure Store_In_Array(c, a : byte);
       var eTmpWord : word;
       begin
       if eHeader.eWidth<80 then eHeader.eWidth := 80;
       eTmpWord := word(c)+word(a shl 8);
       xmsMoveDataTo(eXmsHandle,(eCurPage*eConfigData^.cWidth*2)+eXmsPos,sizeOf(eTmpWord),@eTmpWord);
       inc(eXmsPos,2);
       if ((eXmsPos mod (eHeader.eWidth*2)) = 0) then
        begin
         inc(eCurPage,1);
         eXmsPos := 0;
        end;
       end;

      Procedure eXBinError(str : string);
       begin
       cursor_off;
       gotoXY(1,1);
       textAttr := 48; clrEol;
       skaWrite('|B3|00 '+str+' :: |08Press any key to continue');
       mem[$b800:158] := ord('');
       readKey; while keyPressed do readKey;
       end;

 begin
 if (eCurrentData^.curRes>1) then
  begin
  textAttr := 7;
  gotoXY(1,1);
  skaWrite('|03XB|15i|03N |15i|07mages |15c|07annot |15b|07e |15l|07oaded |15i|07n |0350 |15l|07ine |15m|07ode,'+
           '|15 w|07ould |15y|07ou |15l|07ike |15t|07o |15s|07witch |15m|07odes?|CR');
  skaWrite('|15P|07lease |15e|07nter |15y|07our |15s|07election: ');
  if (eSel=false) then exit;
  eCurrentData^.curRes := 1;
  end;
 eClearXms;
 eXmsPos := 0;
 eCurPage := 0;
 eHasSauce := getSauce(fileName);
 STM_Open(eXBinFile,fileName,NOCREATE);
 STM_Read(eXBinFile,eHeader,Sizeof(eHeader));
 if ((eXBinFile.LastErr<>STM_OK)) then
  begin
  eXBinError('Error, this is not a valid XBiN image!');
  STM_Close(eXBinFile);
  exit;
  end;
 if (eHeader.eBinID<>'XBIN') then
  begin
  eXBinError('Error, this is not a valid XBiN image!');
  STM_Close(eXBinFile);
  exit;
  end;
 if (eHeader.eWidth>eConfigData^.cWidth) then
  begin
  gotoXY(1,1); textAttr := 7; clrEol;
  skaWrite('|15T|07he |15w|07idth |15o|07f |15t|07his |15X|07BiN |15i|07mage (|03'+strr(eHeader.eWidth)+'|07) |15i|07s '+
           '|15g|07reater |15t|07han |15y|07our |15c|07urrent |15s|07ettings..|CR');
  skaWrite('|15W|07ould |15y|07ou |15l|07ike |15t|07o |15t|07emporarily |15c|07hange |15y|07our |15e|07diting |15w|07idth: ');
  if (eSel=false) then exit else eConfigData^.cWidth := eHeader.eWidth;
  end;
 eCompressed := boolean((eHeader.eFlags and $04));
 if ((eHeader.eFlags and $10)<>0) or (eHeader.eFontSize<>16) then
  begin
  eXBiNError('Error, This image uses an unsupported XBiN format');
  STM_Close(eXBinFile);
  exit;
  end;
 if ((eHeader.eFlags and $01)<>0) then
  begin
  STM_Read(eXBinFile,eTmpPal,48);
  for eCount[1] := 0 to 15 do
   for eCount[2] := 1 to 3 do eCurrentData^.curPal[ePaletteID[eCount[1]],eCount[2]] := eTmpPal[eCount[1],eCount[2]];
  end;
 if ((eHeader.eFlags and $02)<>0) then
  STM_Read(eXBinFile,eCurrentData^.curFont,4096);
 if (eHeader.eHeight>0) then
  if (not eCompressed) then for eCount[1] := 1 to eHeader.eHeight do
   begin
    STM_Read(eXBinFile,eBuffer,eHeader.eWidth*2);
    xmsMoveDataTo(eXmsHandle,pred(eCount[1])*eConfigData^.cWidth*2,eHeader.eWidth*2,@eBuffer);
   end else
    begin
    if not eHasSauce then eFileEnd := stm_getSize(eXBinFile) else
     eFileEnd := stm_getSize(eXBinFile)-128;

    WHILE ((eXBinFile.lastErr=stm_ok) and (stm_getPos(eXBinFile)<eFileEnd) and (eCurPage<eHeader.eHeight)) do
    begin
     STM_Read(eXBinFile,Counter,1);
     cType   := Counter and $0C0;
     Counter := Counter and $03F;

     IF (cType = $000) THEN             { No compression }
        FOR i:=1 TO Counter+1 do
         begin
           STM_Read(eXBinFile,char,1);
           STM_Read(eXBinFile,attr,1);
           Store_In_Array (Char, Attr);
        END
     ELSE IF (cTYPE = $040) THEN         { Character compression }
       begin
        STM_Read(eXBinFile,char,1);
        FOR i:=1 TO Counter+1 do begin
           STM_Read(eXBinFile,attr,1);
           Store_In_Array (Char, Attr);
        END;
       end
     ELSE IF (cTYPE = $080) THEN         { Attribute compression }
      begin
        STM_Read(eXBinFile,attr,1);
         FOR i:=1 TO Counter+1 do
         begin
           STM_Read(eXBinFile,char,1);
           Store_In_Array (Char, Attr);
         END
      end
     ELSE begin                          { Character/Attribute compression }
        STM_Read(eXBinFile,char,1);
        STM_Read(eXBinFile,attr,1);
        FOR i:=1 TO Counter+1 do
           Store_In_Array (Char, Attr);
     END;
    END;
    end;
 eCurrentData^.curLength := eHeader.eHeight;
 STM_Close(eXBinFile);
 eSetAdfAll;
 eCurrentData^.CurXBIN := True;
end;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadPipe   (fileName : string);
var eCurAttrib : array[1..2] of byte;
    eCurReal   : array[1..2] of longInt;
    eCurState  : byte;   {0 = char, 1 = pipe, 2 = crlf}
    eBuffer    : array[1..4096] of char;
    eNumRead   : integer;
    eCount     : word;
    eDone      : boolean;
    ePipeCode  : string[2];
    ePipeFile  : file;

    Procedure eAddChar(ch : char);
    var ePair : word;
     begin
     ePair := word(ch)+word(((eCurAttrib[2]*16)+eCurAttrib[1]) shl 8);
     xmsMoveDataTo(eXmsHandle,(eCurReal[2]*eConfigData^.cWidth*2)+(eCurReal[1]*2),2,@ePair);
     if (eCurReal[1]<80) then inc(eCurReal[1],1) else
      begin inc(eCurReal[2],1); eCurReal[1] := 0 end;
     end;

 begin
 eClearXms;
 assign(ePipeFile,fileName);
 reset(ePipeFile,1);
 eCurAttrib[1] := 7;
 eCurAttrib[2] := 0;
 eCurReal[1]   := 0;
 eCurReal[2]   := 0;
  repeat
  fillChar(eBuffer,4096,0);
  blockRead(ePipeFile,eBuffer,4096,eNumRead);
  eCount := 1;
   repeat
   case eBuffer[eCount] of
    '|' : begin eCurState := 1; inc(eCount) end;
    #13 : begin eCurState := 2; inc(eCount,2); end; {kill #10}
   else eCurState := 0;
   end;
   case eCurState of
    0 : begin eAddChar(eBuffer[eCount]); inc(eCount) end;
    1 : begin
        ePipeCode := eBuffer[eCount]+eBuffer[eCount+1];
        if (ePipeCode='CR') then
         begin inc(eCurReal[2]); eCurReal[1] := 0 end else
        if (ePipeCode[1]='B') then eCurAttrib[2] := str2Byte(ePipeCode[2]) else
         eCurAttrib[1] := str2Byte(ePipeCode);
        inc(eCount,2);
        end;
    2 : begin
        inc(eCurReal[2]);
        eCurReal[1] := 0;
        end;
   end;
   if (eCount>=eNumRead) then eDone := true;
   until (eDone=true);
  until (eNumRead<4096) or (eof(ePipeFile)=true);
 close(ePipeFile);
 end;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadPal(fileName : string);
var ePalFile : file;
 begin
 assign(ePalFile,fileName);
 reset(ePalFile,1);
 if (fileSize(ePalFile)<192) then eErrorPause('Error, Invalid palette format') else
  blockRead(ePalFile,eCurrentData^.curPal,192);
 close(ePalFile);
 eSetFullPalette(eCurrentData^.curPal);
 end;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Procedure eLoadFont (FN: String);
Var
  eFontFile : File;
Begin
  Assign (eFontFile, FN);
  Reset  (eFontFile, 1);

  If FileSize(eFontFile) < 4096 Then
    eErrorPause('Error, Invalid font format')
  Else
    BlockRead(eFontFile, eCurrentData^.CurFont, 4096);

  Close(eFontFile);
  eSetAdfFont;
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Function eValidSauce (FN: String) : Boolean;
Var
  eFile      : File;
  eSauceData : eSauceRec;
Begin
  eValidSauce := False;

  Assign (eFile, FN);
  Reset  (eFile, 1);

  If FileSize(eFile) < 128 Then Begin
    Close (eFile);
    Exit;
  End;

  FillChar (eSauceData, SizeOf(eSauceData), 0);

  Seek      (eFile, FileSize(eFile) - 128);
  BlockRead (eFile, eSauceData, 128);

  If eSauceData.eID <> 'SAUCE' Then Begin
    eResetSauceData;
    eSaucePos := FileSize(eFile)
  End Else Begin
    eCurrentData^.curAuthor := eSauceData.eAuthor;
    eCurrentData^.curGroup  := eSauceData.eGroup;
    eCurrentData^.curTitle  := eSauceData.eTitle;

    eSaucePos   := FileSize(eFile) - 128;
    eValidSauce := True;
  End;

  Close(eFile);
End;

{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}

Begin
  GetDir (0, eStartDir);

  If eStartDir[Length(eStartDir)] <> '\' Then eStartDir := eStartDir + '\';

  eLastFile  := 1;
  eLastPos   := 1;
  eLastFirst := 1;
End.