/***************************************************************************
 *                                                                         *
 * avX.c:                                                                  *
 *                                                                         *
 * AcidView For X - main program                                           *
 * Written by Sean Kasun                                                   *
 *                                                                         *
 * Copyright 1995-1998, ACiD Productions                                   *
 *                                                                         *
 ***************************************************************************/


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Shell.h>
#include <stdio.h>
#include "avX.h"
#include "avX-menu.h"
#include "avX-ansi.h"
#include "avX-rip.h"

XtAppContext app_con;
Display *display;
Window window;
Widget topLevel;
Widget frame,menubox,openwin;
Widget owframe,owlframe,owcframe,owview,owlist,owfilter,
owpath,owfilename,owselect,owfilterp;
char curdir[255];
Font dos25font,dos50font;
char showntype=tNone,ansMode=0;
Colormap mycmap;

/* file menu */
static MenuItem filemenu[]={
    {"Exit AcidViewX",&appExit}	/* bye bye */
};
/* edit menu */
static MenuItem editmenu[]={
    {"Copy As Bitmap",NULL}	/* not impl */
};
/* view menu */
static MenuItem viewmenu[]={
    {"Size as 80x25",&appSize},	/* resize to 640x480 */
    {NULL,NULL},		/* line */
    {"Zoom In",NULL},		/* not impl */
    {"Zoom Out",NULL}		/* not impl */
};
/* image menu */
static MenuItem imagemenu[]={
    {"Full Color",&appFull},	/* color */
    {"Grey Scale",NULL},	/* not impl */
    {"Strip Color",&appStrip},	/* ascii */
    {NULL,NULL},		/* line */
    {"25 Line Mode",&appSet25},	/* 16 pixel font */
    {"50 Line Mode",&appSet50}	/* 8 pixel font */
};
/* option menu */
static MenuItem optionmenu[]={
    {"Settings...",NULL},	/* not impl */
    {"Fonts...",NULL}		/* not impl */
};
/* help menu */
static MenuItem helpmenu[]={
    {"Index",NULL},		/* not impl */
    {NULL,NULL},		/* line */
    {"About...",&appAbout}	/* about window */
};

/* create menu bar */
static MenuBar menubar[]={
    {"File","filemenu",filemenu,1},{"Edit","editmenu",editmenu,1},
    {"View","viewmenu",viewmenu,4},{"Image","imagemenu",imagemenu,6},
    {"Options","optionmenu",optionmenu,2},{"Help","helpmenu",helpmenu,3}
};

static int nummasks;
char masks[10][20];
char curmask[255];

static void ReadConfig(void);

int main(int argc,char *argv[])
{
    Widget mask;
    char tempstr[10];
    XColor color;
    XGCValues gcvals;
    XSetWindowAttributes xswa;
    XEvent event;
    XtAppContext appContext;
    int i,chht;
/* our fallbacks */
    static char *fallbackResources[]={
#include "avX.ad.h"
				NULL
    };
/* avX --version  tells us just what we want to know */
    static XrmOptionDescRec optionList[]={
		{"-version","version",XrmoptionIsArg,(XPointer)0}
    };
   printf("AcidView for X v0.05\n");

    ReadConfig();

/* lets ditch Xt and use GTK instead! :) */
    topLevel=XtAppInitialize(&appContext,"avX",optionList,
			 XtNumber(optionList),&argc,argv,
			 fallbackResources,NULL,0);
    app_con=appContext;
/* file choosing frame */
    frame=XtCreateManagedWidget("mainpane",
		panedWidgetClass,topLevel,NULL,0);
/* our menubar */
    menubox=XtCreateManagedWidget("menubar",
		boxWidgetClass,frame,NULL,0);
/* the view window */
    openwin=XtCreateManagedWidget("openwin",
		boxWidgetClass,frame,NULL,0);
    CreateMenuBar(menubar,6);

    filelist=NULL;
    if (!getcwd(curdir,255)) {
		printf("Can't get cwd!\n");
		quit();
    }
    strcpy(curmask,masks[0]);
    updatefiles();
/* all the frames for organization */
    owframe=XtVaCreateManagedWidget("frame",boxWidgetClass,
		openwin,XtNwidth,320,XtNheight,300,NULL);
    owlframe=XtVaCreateManagedWidget("lframe",formWidgetClass,
		owframe,XtNwidth,300,XtNheight,200,NULL);
    owcframe=XtVaCreateManagedWidget("cframe",boxWidgetClass,
		 owframe,NULL);
/* list viewport  */
    owview=XtVaCreateManagedWidget("list",viewportWidgetClass,
		owlframe,XtNallowVert,True,
		 XtNwidth,300,XtNheight,200,NULL);
/* file list */
    owlist=XtVaCreateManagedWidget("list",listWidgetClass,owview,
		 XtNlist,filelist,NULL);
    XtAddCallback(owlist,XtNcallback,(XtCallbackProc)&ReplaceFilename,NULL);
/* filter button */
    owfilter=XtVaCreateManagedWidget("filter",menuButtonWidgetClass,
		 owcframe,XtNmenuName,"filters",
		 XtNlabel,masks[0],NULL);
/* path label */
    owpath=XtVaCreateManagedWidget("path",labelWidgetClass,
		 owcframe,XtNlabel,curdir,NULL);
/* filename textbox */
    owfilename=XtVaCreateManagedWidget("filename",asciiTextWidgetClass,
		 owcframe,XtNeditType,XawtextEdit,
		 XtNwidth,320,NULL);
/* select button */
    owselect=XtVaCreateManagedWidget("Select",commandWidgetClass,
		owcframe,NULL);
    XtAddCallback(owselect,XtNcallback,(XtCallbackProc)&DoSelect,NULL);
/* filters popup */
    owfilterp=XtCreatePopupShell("filters",simpleMenuWidgetClass,
		 owfilter,NULL,0);
/* set filters */
    for (i=0;i<nummasks;i++) {
		sprintf(tempstr,"mask%d",i);
		mask=XtVaCreateManagedWidget(tempstr,smeBSBObjectClass,owfilterp,
			 XtNlabel,masks[i],NULL);
		XtAddCallback(mask,XtNcallback,(XtCallbackProc)&ChangeMask,NULL);
    }

    XtRealizeWidget(topLevel);
    display=XtDisplay(topLevel);
/*Create display window */
    window=XCreateSimpleWindow(display,DefaultRootWindow(display),5,5,
			 640,400,1,
			 BlackPixel(display,DefaultScreen(display)),
			BlackPixel(display,DefaultScreen(display)));
    xswa.backing_store=WhenMapped;
    XChangeWindowAttributes(display,window,CWBackingStore,&xswa);
    XSelectInput(display,window,
		 StructureNotifyMask|KeyPressMask|ButtonPressMask);
/* set window name */
    XStoreName(display,window,"avX Display");
    XSetIconName(display,window,"avXDisplay");
    XMapWindow(display,window);

/* bitch if we can't find the fonts */		
    if ((dos25font=XLoadFont(display,"pc8x16s"))==0) {
		printf("Couldn't load font:pc8x16s\n");
		printf("Did you 'make install'?  Did you restart X11?\n");
		quit();
    }
    if ((dos50font=XLoadFont(display,"pc8x8s"))==0) {
		printf("Couldn't load font:pc8x8s\n");
		printf("Did you 'make install'?  Did you restart X11?\n");
		quit();
    }
	mycmap=0;
	ansbuf=NULL;
    ansofs=lines=0;
    width=640;
    height=400;

/* dear god! a goto loop?! ;) */		
  lp:
	/* get event */
    XtAppNextEvent(app_con,&event);
    chht=16;
    if (ansMode==1)
			chht=8;
    switch (event.type) {
	/* hit a key */
      case KeyPress:
		/* in display window */
		if (event.xkey.window==window) {
		/* up! */
		if (event.xkey.keycode==kUp && ansofs>0) {
			ansofs--;
			Redraw();
		}
		/* down! */
		if (event.xkey.keycode==kDown && ansofs<lines-(height/chht)) {
			ansofs++;
			Redraw();
		}
		/* pgup! */
		if (event.xkey.keycode==kPgUp && ansofs>0) {
			ansofs-=(height/chht);
			if (ansofs<0)
				ansofs=0;
			Redraw();
		}
		/* pgdown! */
		if (event.xkey.keycode==kPgDown && ansofs<lines-(height/chht)) {
			ansofs+=(height/chht);
			if (ansofs>lines-(height/chht))
				ansofs=lines-(height/chht);
			Redraw();
		}
		/* home! */
		if (event.xkey.keycode==kHome) {
			ansofs=0;
			Redraw();
		}
		/* end! */
		if (event.xkey.keycode==kEnd) {
			ansofs=lines-(height/chht);
			if (ansofs<0)
				ansofs=0;
			Redraw();
		}
	}
	break;
	/* oop, resized */
      case ConfigureNotify:
		if (event.xconfigure.window==window) {
			width=event.xconfigure.width;
			height=event.xconfigure.height;
			Redraw();
		}
		break;
	/* someone hit a mouse button */
      case ButtonPress:
		/* in display window? */
		if (event.xbutton.window==window) {
			/* scroll down */
			if (event.xbutton.button==1) {
				ansofs+=(height/(chht*2));
				if (ansofs>lines-(height/chht))
					ansofs=lines-(height/chht);
				Redraw();
			}
			/* scroll up */
			if (event.xbutton.button==3) {
				ansofs-=(height/(chht*2));
				if (ansofs<0)
					ansofs=0;
				Redraw();
			}
		}
    }
	/* otherwise, dispatch that bastard */
    XtDispatchEvent(&event);
    goto lp;
}

/* where we go when we die */
void quit()
{
    unsigned long pixels[16];
    XGCValues vals;
    int i;
		
    if (dos25font!=0)
      XUnloadFont(display,dos25font);	/* bye font */
    if (dos50font!=0)
      XUnloadFont(display,dos50font);	/* bye font */
    if (ansbuf!=NULL)
      free(ansbuf);			/* bye ansi */
    if (mycmap!=0)
      XFreeColormap(display,mycmap);	/* bye colormap */
    for (i=0;;i++) {
	if (filelist[i]==NULL)
		break;
	XtFree((char *)filelist[i]);	/* bye filelist entry */
    }
    XtFree((char *)filelist);		/* bye filelist */
    XtDestroyApplicationContext(app_con); /* bye app! */
    exit(0);
}

/* configure info */
static int affect(char *var,char *value)
{
    char *tptr;
    int tmpint;
    char tmpchar;
    if (!strcmp(var,"packdir") && value[0]) {
		strcpy(curdir,value);
		return 0;
    }
    if (var[0]=='m' && var[1]=='a' && var[2]=='s' && var[3]=='k') {
		tmpchar=var[4];
		tmpint=tmpchar-'1';
		strcpy(masks[tmpint],value);
		nummasks=tmpint+1;
		return 0;
    }
    return -1;
}

/* read config, .avXrc */
static void ReadConfig()
{
    char HomePath[255];
    char RCLine[255],var[100],value[100];
    int count=0,i;
    FILE *cfg;
    char *pt;
    if ((pt=(char *)getenv("HOME"))==NULL) {
				printf("Couldn't find HOME\n");
				exit(1);
    }
    strcpy(curdir,".");
    nummasks=3;
    strcpy(masks[0],"*.ans");
    strcpy(masks[1],"*.rip");
    strcpy(masks[2],"*");

    strcpy(HomePath,pt);
    strcat(HomePath,"/.avXrc");
    printf("Opening %s\n",HomePath);
    if ((cfg=fopen(HomePath,"rb"))!=NULL) {
	while (fgets(RCLine,255,cfg)) {
		count++;
	if (RCLine[0]!='#' && (strlen(RCLine)>=(unsigned)2)) {
		var[0]=value[0]='\0';
		sscanf(RCLine,"%s %s",var,value);
		if (affect(var,value)==-1) {
			printf("Error in .avXrc (line %d)\n",count);
			printf("%d : %s\n",count,RCLine);
			fclose(cfg);
			return;
		}
	}
	}
	chdir(curdir);
	fclose(cfg);
	return;
    }
}



